/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.FlowerBoxBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.FlowerPotHandler;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class FlowerBoxBakedModel
implements IDynamicBakedModel {
    private final IBakedModel box;
    private final BlockModelShapes blockModelShaper;

    public FlowerBoxBakedModel(IBakedModel box) {
        this.box = box;
        this.blockModelShaper = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.box.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BlockState[] flowers = new BlockState[]{(BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_0), (BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_1), (BlockState)extraData.getData(FlowerBoxBlockTile.FLOWER_2)};
            MatrixStack matrixStack = new MatrixStack();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            float yaw = -((Direction)state.func_177229_b((Property)FlowerBoxBlock.FACING)).func_176734_d().func_185119_l();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
            matrixStack.func_227861_a_(-0.3125, -0.1875, 0.0);
            if (((Boolean)state.func_177229_b((Property)FlowerBoxBlock.FLOOR)).booleanValue()) {
                matrixStack.func_227861_a_(0.0, 0.0, -0.3125);
            }
            matrixStack.func_227862_a_(0.625f, 0.625f, 0.625f);
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227861_a_(-0.5, 0.0, 0.0);
            for (int i = 0; i < 3; ++i) {
                BlockState flower = flowers[i];
                if (flower != null && !flower.func_196958_f()) {
                    this.addBlockToModel(i, quads, flower, matrixStack, side, rand);
                    if (flower.func_235901_b_((Property)DoublePlantBlock.field_176492_b)) {
                        matrixStack.func_227861_a_(0.0, 1.0, 0.0);
                        this.addBlockToModel(i, quads, (BlockState)flower.func_206870_a((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER), matrixStack, side, rand);
                        matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                    }
                }
                matrixStack.func_227861_a_(0.5, 0.0, 0.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    private void addBlockToModel(int index, List<BakedQuad> quads, BlockState state, MatrixStack matrixStack, @Nullable Direction side, @Nonnull Random rand) {
        IBakedModel model;
        ResourceLocation res = FlowerPotHandler.getSpecialFlowerModel(state.func_177230_c().func_199767_j());
        if (res != null) {
            if (state.func_235901_b_((Property)DoublePlantBlock.field_176492_b) && state.func_177229_b((Property)DoublePlantBlock.field_176492_b) == DoubleBlockHalf.UPPER) {
                return;
            }
            model = this.blockModelShaper.func_178126_b().func_174953_a(new ModelResourceLocation(res.toString()));
        } else {
            model = this.blockModelShaper.func_178125_b(state);
        }
        List mimicQuads = model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
        for (BakedQuad q : mimicQuads) {
            int[] v = Arrays.copyOf(q.func_178209_a(), q.func_178209_a().length);
            if (res == null) {
                v = RendererUtil.moveVertices(v, -0.5f, -0.5f, -0.5f);
                v = RendererUtil.scaleVertices(v, 0.6249f);
            } else {
                v = RendererUtil.moveVertices(v, -0.5f, -0.3125f, -0.5f);
            }
            v = RendererUtil.transformVertices(v, matrixStack);
            quads.add(new BakedQuad(v, q.func_178211_c() >= 0 ? index : q.func_178211_c(), q.func_178210_d(), q.func_187508_a(), q.func_239287_f_()));
        }
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.box.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }
}

